using System;

namespace SPStudio
{
	/// <summary>
	/// Holds two Vector2Ds to represent a line
	/// in 2D space.
	/// Knows how to convert itself into a
	/// Line3D.
	/// </summary>
	public class Line2D
	{
		#region Private Vars
		private Vector2D p1 = new Vector2D();
		private Vector2D p2 = new Vector2D();
		#endregion

		#region Constructors
		/// <summary>
		/// Default constructor that
		/// uses the Vector2D default constructor
		/// to assign both points.
		/// </summary>
		public Line2D()
		{
		}

		/// <summary>
		/// Assigns both points using
		/// the Vector2D constructor that
		/// asscepts System.Drawing.Point
		/// </summary>
		/// <param name="P1"></param>
		/// <param name="P2"></param>
		public Line2D(System.Drawing.Point P1, System.Drawing.Point P2)
		{
			p1 = new Vector2D(P1);
			p2 = new Vector2D(P2);
		}
		#endregion

		#region Handle Conversion to Line3D
		/// <summary>
		/// Convert Line2D to Line3D by translating
		/// the x and y components by treating the center
		/// of the image as (0.0,0.0) instead of the upper left corner.
		/// Then assign a z value of 0.0
		/// </summary>
		/// <param name="imageSize"></param>
		/// <returns></returns>
		public Line3D convertAndTranslate(System.Drawing.Size imageSize)
		{
			int halfHeight = imageSize.Height/2;
			int halfWidth = imageSize.Width/2;

			//Vector2D's convert method returns
			//a Vector3D that has the same x and y
			//as the original vector, but includes
			//a z of 0.0
			Vector3D p1_3D = p1.convertToVector3D();
			Vector3D p2_3D = p2.convertToVector3D();

			//Translate the x and y components
			p1_3D.x -= halfWidth;
			p1_3D.y	-= halfHeight;
			p2_3D.x -= halfWidth;
			p2_3D.y	-= halfHeight;
			p1_3D.y = (-1.0)*p1_3D.y;
			p2_3D.y = (-1.0)*p2_3D.y;

			return new Line3D(p1_3D, p2_3D);
		}
		#endregion
	}
}
